Attribute VB_Name = "MdlFileStampUpdate"
'/* TimeStamp W[ */
Option Explicit


' CreateFile ֐
Private Declare Function CreateFile Lib "KERNEL32.DLL" Alias "CreateFileA" ( _
    ByVal lpFileName As String, _
    ByVal dwDesiredAccess As Long, _
    ByVal dwShareMode As Long, _
    ByVal lpSecurityAttributes As Long, _
    ByVal dwCreationDisposition As Long, _
    ByVal dwFlagsAndAttributes As Long, _
    ByVal hTemplateFile As Long _
) As Long


' CloseHandle ֐
Private Declare Function CloseHandle Lib "KERNEL32.DLL" (ByVal hObject As Long) As Long


' LocalFileTimeToFileTime ֐
Private Declare Function LocalFileTimeToFileTime Lib "KERNEL32.DLL" (ByRef lpLocalFileTime As FileTime, ByRef lpFileTime As FileTime) As Long


' SystemTimeToFileTime ֐
Private Declare Function SystemTimeToFileTime Lib "KERNEL32.DLL" (ByRef lpSystemTime As SystemTime, ByRef lpFileTime As FileTime) As Long


' SetFileTime ֐
Private Declare Function SetFileTime Lib "KERNEL32.DLL" ( _
    ByVal cFile As Long, _
    ByRef lpCreationTime As FileTime, _
    ByRef lpLastAccessTime As FileTime, _
    ByRef lpLastWriteTime As FileTime _
) As Long


' SystemTime \
Private Type SystemTime
    Year         As Integer
    Month        As Integer
    DayOfWeek    As Integer
    Day          As Integer
    Hour         As Integer
    Minute       As Integer
    Second       As Integer
    Milliseconds As Integer
End Type


' FileTime \
Private Type FileTime
    LowDateTime  As Long
    HighDateTime As Long
End Type

' 萔̒`
Private Const GENERIC_READ          As Long = &H80000000
Private Const GENERIC_WRITE         As Long = &H40000000
Private Const FILE_SHARE_READ       As Long = &H1
Private Const FILE_ATTRIBUTE_NORMAL As Long = &H80
Private Const OPEN_EXISTING         As Long = 3


' FileTime 擾
Private Function GetFileTime(ByVal dtSetting As Date) As FileTime
    Dim tSystemTime As SystemTime

    With tSystemTime
        .Year = Year(dtSetting)
        .Month = Month(dtSetting)
        .DayOfWeek = Weekday(dtSetting)
        .Day = Day(dtSetting)
        .Hour = Hour(dtSetting)
        .Minute = Minute(dtSetting)
        .Second = Second(dtSetting)
    End With

    Dim tLocalTime As FileTime
    Call SystemTimeToFileTime(tSystemTime, tLocalTime)

    Dim tFileTime As FileTime
    Call LocalFileTimeToFileTime(tLocalTime, tFileTime)

    GetFileTime = tFileTime
End Function


' t@C̃nh擾
Private Function GetFileHandle(ByVal stFilePath As String) As Long
    GetFileHandle = CreateFile( _
        stFilePath, GENERIC_READ Or GENERIC_WRITE, _
        FILE_SHARE_READ, 0, OPEN_EXISTING, _
        FILE_ATTRIBUTE_NORMAL, 0 _
    )
End Function


' -------------------------------------------------------------------------------
'       쐬w肵tƎԂɐݒ肵܂B
'
' @Param    stFilePath      쐬ݒ肷t@C܂ł̃pXB
' @Param    dtCreateTime    쐬ɐݒ肷tƎԁB
' -------------------------------------------------------------------------------
Public Sub SetCreationTime(ByVal stFilePath As String, ByVal dtCreateTime As Date)
    ' FileTime 擾
    Dim tFileTime As FileTime
    tFileTime = GetFileTime(dtCreateTime)

    ' t@C̃nh擾
    Dim cFileHandle As Long
    cFileHandle = GetFileHandle(stFilePath)

    ' t@C̃nh擾łꍇ̂݁u쐬vXV
    If cFileHandle >= 0 Then
        Dim tNullable As FileTime

        Call SetFileTime(cFileHandle, tFileTime, tNullable, tNullable)
        Call CloseHandle(cFileHandle)
    End If
End Sub


' -------------------------------------------------------------------------------
'       XVw肵tƎԂɐݒ肵܂B
'
' @Param    stFilePath      XVݒ肷t@C܂ł̃pXB
' @Param    dtUpdateTime    XVɐݒ肷tƎԁB
' -------------------------------------------------------------------------------
Public Sub SetLastWriteTime(ByVal stFilePath As String, ByVal dtUpdateTime As Date)
    ' FileTime 擾
    Dim tFileTime As FileTime
    tFileTime = GetFileTime(dtUpdateTime)

    ' t@C̃nh擾
    Dim cFileHandle As Long
    cFileHandle = GetFileHandle(stFilePath)

    ' t@C̃nh擾łꍇ̂݁uXVvXV
    If cFileHandle >= 0 Then
        Dim tNullable As FileTime

        Call SetFileTime(cFileHandle, tNullable, tNullable, tFileTime)
        Call CloseHandle(cFileHandle)
    End If
End Sub


' -------------------------------------------------------------------------------
'       ANZXw肵tƎԂɐݒ肵܂B
'
' @Param    stFilePath      ANZXݒ肷t@C܂ł̃pXB
' @Param    dtAccessTime    ANZXɐݒ肷tƎԁB
' -------------------------------------------------------------------------------
Public Sub SetLastAccessTime(ByVal stFilePath As String, ByVal dtAccessTime As Date)
    ' FileTime 擾
    Dim tFileTime As FileTime
    tFileTime = GetFileTime(dtAccessTime)

    ' t@C̃nh擾
    Dim cFileHandle As Long
    cFileHandle = GetFileHandle(stFilePath)

    ' t@C̃nh擾łꍇ̂݁uANZXvXV
    If cFileHandle >= 0 Then
        Dim tNullable As FileTime

        Call SetFileTime(cFileHandle, tNullable, tFileTime, tNullable)
        Call CloseHandle(cFileHandle)
    End If
End Sub

